<?php

get_header();

$show_default_title = get_post_meta( get_the_ID(), '_et_pb_show_title', true );

$is_page_builder_used = et_pb_is_pagebuilder_used( get_the_ID() );

?>

<div id="pagina-artigo">
	<div id="main-content">
		<?php
			if ( et_builder_is_product_tour_enabled() ):
				// load fullwidth page in Product Tour mode
				while ( have_posts() ): the_post(); ?>

					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="entry-content">
						<?php
							the_content();
						?>
						</div> <!-- .entry-content -->

					</article> <!-- .et_pb_post -->

			<?php endwhile;
			else:
		?>

		<div class="container-fluid">
			<div id="content-area" class="clearfix">
				<?php while ( have_posts() ) : the_post(); ?>
					<?php if (et_get_option('divi_integration_single_top') <> '' && et_get_option('divi_integrate_singletop_enable') == 'on') echo(et_get_option('divi_integration_single_top')); ?>

					<article id="post-<?php the_ID(); ?>" <?php post_class( 'et_pb_post' ); ?>>
						<?php if ( ( 'off' !== $show_default_title && $is_page_builder_used ) || ! $is_page_builder_used ) { ?>
							<div class="et_post_meta_wrapper header-custom-artigos">

							<?php
								if ( ! post_password_required() ) :

									et_divi_post_meta();

									$thumb = '';

									$width = (int) apply_filters( 'et_pb_index_blog_image_width', 1916 );
									$height = (int) apply_filters( 'et_pb_index_blog_image_height', 534 );
									$classtext = 'et_featured_image';
									$titletext = get_the_title();
									$thumbnail = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
									$thumb = $thumbnail["thumb"];

									$post_format = et_pb_post_format();

									if ( 'video' === $post_format && false !== ( $first_video = et_get_first_video() ) ) {
										printf(
											'<div class="et_main_video_container">
												%1$s
											</div>',
											$first_video
										);
									} else if ( ! in_array( $post_format, array( 'gallery', 'link', 'quote' ) ) && 'on' === et_get_option( 'divi_thumbnails', 'on' ) && '' !== $thumb ) {
										print_thumbnail( $thumb, $thumbnail["use_timthumb"], $titletext, $width, $height );
									} else if ( 'gallery' === $post_format ) {
										et_pb_gallery_images();
									}
								?>

								<?php
									$text_color_class = et_divi_get_post_text_color();

									$inline_style = et_divi_get_post_bg_inline_style();

									switch ( $post_format ) {
										case 'audio' :
											$audio_player = et_pb_get_audio_player();

											if ( $audio_player ) {
												printf(
													'<div class="et_audio_content%1$s"%2$s>
														%3$s
													</div>',
													esc_attr( $text_color_class ),
													$inline_style,
													$audio_player
												);
											}

											break;
										case 'quote' :
											printf(
												'<div class="et_quote_content%2$s"%3$s>
													%1$s
												</div> <!-- .et_quote_content -->',
												et_get_blockquote_in_content(),
												esc_attr( $text_color_class ),
												$inline_style
											);

											break;
										case 'link' :
											printf(
												'<div class="et_link_content%3$s"%4$s>
													<a href="%1$s" class="et_link_main_url">%2$s</a>
												</div> <!-- .et_link_content -->',
												esc_url( et_get_link_url() ),
												esc_html( et_get_link_url() ),
												esc_attr( $text_color_class ),
												$inline_style
											);

											break;
									}

								endif;
							?>
						</div> <!-- .et_post_meta_wrapper -->

						<div class="container content-inner-custom">
							<?php  } ?>

							<div class="entry-content">
								<div class="linha-categoria">
									<?php
										$cats = get_the_category($post->ID);
										/*if ( $cats[0]->term_id == '3273') { // id da categoria
	       										unset($cats[0]);
	    									}
										$cats = array_values($cats);*/
										$parent = get_category($cats[0]->category_parent);
										if (is_wp_error($parent)){
											$cat = get_category($cats[0]);
										}else{
											$cat = $parent;
										}
									?>
									<div style="background-color: <?php echo $cat->description; ?> ;" class="btn-categoria <?php echo $cat->slug; ?>">
										<?php echo $cat->name; ?>
									</div>
								</div>

								<h1 class="entry-title entry-title-custom"><?php the_title(); ?></h1>

								<p class="autor-name">Escrito por: <strong><?php the_author(); ?></strong></p>

								<p class="breadcrumbs-artigo">
									<span>
										<span>
											<a href="<?php echo get_home_url(); ?>">
												<i class="fa fa-home"></i>
											</a> • 
											<span>
											<!--<a href="<?php echo get_home_url() . "/" .$cat->slug;?>">-->
													<?php echo $cat->name; ?> 
												<!--</a>--> • 
												<strong class="breadcrumb_last">Post</strong>
											</span>
										</span>
									</span>
								</p>

								<?php
									do_action( 'et_before_content' );
									the_content();
									wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'Divi' ), 'after' => '</div>' ) );
								?>

							</div> <!-- .entry-content -->
							<div class="autor-artigo">
								<?php if (function_exists('get_avatar')) { echo get_avatar( get_the_author_email(), '100' ); }?>

								<h3><?php the_author(); ?></h3>
								<p><?php the_author_description(); ?></p>

							</div>


						</div>
					</article> <!-- .et_pb_post -->

					<div class="container-fluid content-artigos-relacionados">
						<div class="container">
							<h2 class="title-relacionados">Artigos Relacionados</h2>
							<?php ll_related_posts(); ?>
						</div>
					</div>
			

					<div class="container-fluid content-comments-custom">
						<div class="container">
							<div class="comments-face">
								<h2><strong>Deixe seu comentário</strong></h2>
								<p><?php echo do_shortcode("[gs-fb-comments]"); ?> </p>
							</div>
						</div>
					</div>

				<?php endwhile; ?>

				<?php get_sidebar(); ?>

			</div> <!-- #content-area -->
		</div> <!-- .container -->
		<?php endif; ?>
	</div> <!-- #main-content -->
</div>
<?php

get_footer();
